//=============================================================================
// BarretProj. BY {FHG}ShadowSniper
//=============================================================================
class BarretProj extends Projectile;

var float SmokeRate;
var int NumExtraRockets;
var	rockettrail Trail;

simulated function Destroyed()
{
	if ( Trail != None )
		Trail.Destroy();
	Super.Destroyed();
}

simulated function PostBeginPlay()
{


	NumExtraRockets=1;

	Trail = Spawn(class'RocketTrail',self);

	SoundRadius = 6;
	LightRadius = 3;

	SetTimer(0.001, true);
}

simulated function Timer()
{
	local ut_SpriteSmokePuff b;

	if ( Region.Zone.bWaterZone || (Level.NetMode == NM_DedicatedServer) )
		Return;

	Spawn(class'BarretWave');
	//SmokeRate = 40/Speed;
	SetTimer(0.001, false);
}


function SuperExplosion()
{
	local BarretShock r;

	HurtRadius(Damage*3.9, 240, 'jolted', MomentumTransfer*2, Location );

	r = Spawn(Class'BarretShock',,'',Location, Instigator.ViewRotation);
	//r.PlaySound(r.EffectSound1,,20.0,,1000,0.6);
	Destroy();
}

auto state Flying
{
	function ProcessTouch (Actor Other, vector HitLocation)
	{

		If (Other!=Instigator  && BarretProj(Other)==None)
		{
			Explode(HitLocation,Normal(HitLocation-Other.Location));
		}
	}

	function BeginState()
	{
		Velocity = vector(Rotation) * speed;
	}
}


function Explode(vector HitLocation,vector HitNormal)
{
	local BarretShock r;

	PlaySound(ImpactSound, SLOT_Misc, 0.5,,, 0.5+FRand());
	HurtRadius(Damage, 200, 'jolted', MomentumTransfer, Location );

	r = Spawn(class'BarretShock',,, HitLocation+HitNormal*8,rotator(HitNormal));

	//r.PlaySound(r.EffectSound1,,6);
	Destroy();
}

defaultproperties
{
    speed=8000.00
    MaxSpeed=9000.00
    Damage=80.00
    MomentumTransfer=30000
    ImpactSound=Sound'UnrealShare.General.Expla02'
    bNetTemporary=False
    RemoteRole=2
    LifeSpan=10.00
    Mesh=LodMesh'UnrealShare.TazerProja'
    bUnlit=True
    CollisionRadius=12.00
    CollisionHeight=12.00
    bProjTarget=True
    LightType=1
    LightEffect=13
    LightBrightness=101
    LightHue=165
    LightSaturation=72
    LightRadius=6
    bFixedRotationDir=True
    RotationRate=(Pitch=0,Yaw=0,Roll=50000),
    DesiredRotation=(Pitch=0,Yaw=0,Roll=30000),
}
